/******************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audioroutemanager.cpp
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audioroutemanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
*******************************************************************************/

/*******************************************************************************
                        Includes

*******************************************************************************/

#include "include/audiomanagertypes.h"

/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
/* Include AudioRoute Manager FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include <midw_fi_if.h>

#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "CAmControlSenderBase.h"
#include "controllerplugin_Trace.h"
/* Needed for Trace */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>

#ifndef USE_DLT_TRACE
//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/amcontrol_clienthandler_fc_audioroutemanager.cpp.trc.h"
#endif

//#include "common.h"
#include <cca_if.h>


//#include "control/IAmControlReceive.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
using namespace AudioStack;
using namespace AudioStack::AudioSource;


/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audioroutemanager
 *DESCRIPTION  : constructor for class amcontrol_clienthandler_fc_audioroutemanager
 *PARAMETER    : am::IAmRoutingReceiverShadow*
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audioroutemanager::amcontrol_clienthandler_fc_audioroutemanager(CAmControlSenderBase& controlSenderBase, am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive)
   : CThreadSwitchingClient(MIDW_AUDIO_ROUTE_MGRFI_C_U16_SERVICE_ID, MIDW_AUDIO_ROUTE_MGRFI_C_SERVICE_VERSION_1_0, receiverShadow)
   , m_ControlSenderBase(controlSenderBase)
   , m_ControlReceive(controlReceive)
   , m_RoutingReadyHandle(0)

{
   ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::Entered in constructor amcontrol_clienthandler_fc_audioroutemanager()"));
}

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audioroutemanager
 *DESCRIPTION  : destructor for class amcontrol_clienthandler_fc_audioroutemanager
 *PARAMETER    : void
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audioroutemanager::~amcontrol_clienthandler_fc_audioroutemanager(void)
{
   ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::Entered in destructor amcontrol_clienthandler_fc_audioroutemanager()"));
}

/************************************************************************
 *FUNCTION     : vOnSourceAvailability
 *DESCRIPTION  : callback for property SourceAvailability
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *28.11.2013   Rev 1.0     R.Volkmer
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_SourceAvailability
 ************************************************************************/
bool amcontrol_clienthandler_fc_audioroutemanager::bOnSourceAvailabilityStatus (const FIMessaging::FIMessage& oMsg)
{
   //Get the data using Helper function
   midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus oStatus;
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnSourceAvailabilityStatus() . E R R O R :  failed reading SourceAvailability.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   std::vector<midw_fi_tcl_SourceAvailablityItem>::const_iterator SrcAvailIterator;

   if(oStatus.SourceAvailabilityList.empty())
   {
     ETG_TRACE_USR3(("bOnSourceAvailabilityStatus: SourceAvailabilityList is empty"));
   }
   else
   {
     for(SrcAvailIterator = oStatus.SourceAvailabilityList.begin();
         SrcAvailIterator != oStatus.SourceAvailabilityList.end();
         ++SrcAvailIterator)
     {
       midw_fi_tcl_e8_AudSource::tenType Source             = (*SrcAvailIterator).u8Source.enType;
       tU16 SubSourceID                                     = (*SrcAvailIterator).u16SubSource;
       midw_fi_tcl_e8_SrcAvailability::tenType Availability = (*SrcAvailIterator).e8Availability.enType;
       midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason = (*SrcAvailIterator).e8Reason.enType;

       ETG_TRACE_USR4(("bOnSourceAvailabilityStatus:\t SourceClass= %d, SubSource= %d, Availability= %d, Reason= %d",
           (tU8)Source, (tU16)SubSourceID, (tU8)Availability, (tU8)Reason));

       //am_mainConnectionID_t mainConnectionID;

       clGeniviAudioCtrlAdapter::SourceAvailabilityChange(Source,
           SubSourceID,
           Availability,
           Reason);
     }
   }
   //clGeniviAudioCtrlAdapter::handleSourceStatus(oSrcRouteActStatus.SourceRouteActivity.Source.enType,
   //      oSrcRouteActStatus.SourceRouteActivity.Activity.enType);

   return true;
}

/************************************************************************
 *FUNCTION     : vOnSourceRouteActivity
 *DESCRIPTION  : callback for property SourceRouteActivity
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
bool amcontrol_clienthandler_fc_audioroutemanager:: bOnSourceRouteActivityStatus (const FIMessaging::FIMessage& oMsg)
{
     //Get the data using Helper function
  midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus oStatus;
  if ( ! oMsg.bPopulateFIData(oStatus))
  {
    ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus() . E R R O R :  failed reading SourceRouteActivity.Status from %x with size %d"
        , oMsg.pPayload, oMsg.u32PayloadLength))
        return false;
  }

  ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus: source= %d, SubID= %d, PossibleNextSource= %d, Activity= %d, Sink= %d",
      oStatus.SourceRouteActivity.Source.enType, oStatus.SourceRouteActivity.SubSource,
      oStatus.SourceRouteActivity.PossibleNextSource.enType, oStatus.SourceRouteActivity.Activity.enType,
      oStatus.SourceRouteActivity.Resource.enType));
  // daw2hi we could also have an error here inside the status
  if(oStatus.ErrorCode != 0)
  {
    // This is an error report

    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus, Src= %d, SubSrc= %d, Status with error= %d",
        oStatus.SourceRouteActivity.Source.enType, oStatus.SourceRouteActivity.SubSource, oStatus.ErrorCode));

    clGeniviAudioCtrlAdapter::vHandleSourceError(oStatus.SourceRouteActivity.Source.enType,
        oStatus.SourceRouteActivity.SubSource, oStatus.ErrorCode);
  }
  else
  {
    clGeniviAudioCtrlAdapter::handleSourceStatus(oStatus.SourceRouteActivity.Activity.enType,
        oStatus.SourceRouteActivity.Source.enType,
        oStatus.SourceRouteActivity.SubSource,
        oStatus.SourceRouteActivity.Resource.enType);
  }

  am_Sink_s sinkData;
  am_sinkID_t sinkID = oStatus.SourceRouteActivity.Resource.enType;
  am_Error_e eCode = m_ControlReceive.getSinkInfoDB(SINK_ID_ADR3,sinkData);
  //m_ControlReceive.getSinkInfoDB(sinkID, sinkData);
  ETG_TRACE_USR4(("bOnSourceRouteActivityStatus() with sinkID %d, getSinkInfoDB(SINK_ID_ADR3,sinkData) returned err %d",sinkID,eCode));
  //update DB with mute status
  switch(oStatus.SourceRouteActivity.Activity.enType)
  {
  case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
  {
#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_PSA)
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(ON),calling changeSinkMuteStateDB(MS_UNMUTED)"));
      clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(MS_UNMUTED, SINK_ID_ADR3);
#else
    bool bUpdateMuteUnmuteStatus = false;
    //vdu1kor check if source is mix/announcement source then update to HMI for mute/unMute is not required (SUZUKI-17070 && SUZUKI-17092)
    if(clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(oStatus.SourceRouteActivity.Source.enType,(tU8) oStatus.SourceRouteActivity.SubSource)){
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(), new source is mix/announcement source, No need to send Mute/UnMute update"));
    }
    else{
      bUpdateMuteUnmuteStatus = true;
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(),new source is not mix/announcement source, send mute/unMute update"));
    }
    //Emit signal "MS_UNMUTED" only if current sink state is "MS_MUTED"
    if(bUpdateMuteUnmuteStatus)
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(ON),calling changeSinkMuteStateDB(MS_UNMUTED)"));

      //m_ControlReceive.changeSinkMuteStateDB(MS_UNMUTED, SINK_ID_ADR3);
      clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(MS_UNMUTED, SINK_ID_ADR3);
    }
    else
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(ON),already sink muteState is MS_UNMUTED"));
    }
    break;
#endif
  }
  case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
  case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
  {
    const clSourceClass* pSrcClass_EntMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_ENTERTAIN");
    if(pSrcClass_EntMute == NULL)
    {
      ETG_TRACE_ERR(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(OFF/PAUSE): ERROR no source class MUTE_ENTERTAIN"));
      return true;
    }

    //Emit signal "MUTED" only if active source is "MUTE_ENTERTAIN" and current sink state is "MS_UNMUTED"
    if(true == clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID(pSrcClass_EntMute->getClassID(),0)))
    {
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(OFF/PAUSE), Current active source is MUTE_ENTERTAIN, calling changeSinkMuteStateDB(MS_MUTED)"));

      //m_ControlReceive.changeSinkMuteStateDB(MS_MUTED, SINK_ID_ADR3);
      clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(MS_MUTED, SINK_ID_ADR3);
    }
    else{
      ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(OFF/PAUSE), Current active source is not MUTE_ENTERTAIN, Not required to call changeSinkMuteStateDB(MS_MUTED)"));
    }

    break;
  }
  default :
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::bOnSourceRouteActivityStatus(UNKNOWN)"));
    break;
  }
  }//End of Switch

  return true;
}
/************************************************************************/

bool amcontrol_clienthandler_fc_audioroutemanager:: bOnSourceRouteActivityError (const FIMessaging::FIMessage& oMsg)
{
   FIMessaging::FunctionInfo info(GetServiceInfo(), MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY, FIMessaging::enError);
   FIMessaging::fi_tclErrorMsg oError(info);

   if ( ! oMsg.bPopulateFIData(oError))
   {
     ETG_TRACE_ERR(("bOnSourceAvailabilityStatus() . E R R O R :  failed reading SourceRouteActivity.Error from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   tU16 u16ErrorCode = oError.u16ErrorCode;

   midw_fi_tcl_e8_AudSource::tenType SourceError = static_cast<midw_fi_tcl_e8_AudSource::tenType>(u16ErrorCode >> 8);

   ETG_TRACE_USR4(("bOnSourceRouteActivityError: Calling vHandleSourceError,u16ErrorCode:%d, SourceError: %d, No more Supported",
       u16ErrorCode, SourceError));

   // no more supported as this was anyhow insufficient due to missing subsource
   //SourceError = static_cast<midw_fi_tcl_e8_AudSource::tenType>(2);
   //clGeniviAudioCtrlAdapter::vHandleSourceError(SourceError);

   return true;
}

/************************************************************************
 *FUNCTION     : vOnRequestAudioRoute
 *DESCRIPTION  : callback for property RequestAudioRoute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *10.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *04.02.2015   : Martin Koch, Fa. ESE - merge CAmControlSenderBase::vResponse_AudioRoute
 ************************************************************************/
bool amcontrol_clienthandler_fc_audioroutemanager:: bOnRequestAudioRouteStatus (const FIMessaging::FIMessage& oMsg)
{

   //Get the data using Helper function
   midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus oStatus;
   if ( ! oMsg.bPopulateFIData(oStatus))
   {
     ETG_TRACE_ERR(("bOnSourceAvailabilityStatus() . E R R O R :  failed reading RequestAudioRoute.Status from %x with size %d"
           , oMsg.pPayload, oMsg.u32PayloadLength))
     return false;
   }

   std::vector<midw_fi_tcl_RequestAudioRouteItem>::const_iterator ReqRouteIterator;

   if(oStatus.RequestAudioRouteList.empty())
   {
     ETG_TRACE_USR4(("CAmControlSenderBase::vResponse_AudioRoute,RequestAudioRouteList is empty"));
   }
   else
   {
     for(ReqRouteIterator = oStatus.RequestAudioRouteList.begin();
         ReqRouteIterator != oStatus.RequestAudioRouteList.end();
         ++ReqRouteIterator)
     {
       midw_fi_tcl_e8_AudSource::tenType Source     = (*ReqRouteIterator).u8Source.enType;
       tU16 SubSourceID                             = (*ReqRouteIterator).u16SubSource;
       midw_fi_tcl_e8_SrcActivity::tenType Activity = (*ReqRouteIterator).e8Activity.enType;
       tU8  Reason                                  = (*ReqRouteIterator).u8Reason;




       //am_mainConnectionID_t mainConnectionID;

       sourceClassID enInternalSrcClass =
           clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(Source);


       if(clFactory_AudioSourceClass::GetInvalidSourceClass() != enInternalSrcClass){
         if((*ReqRouteIterator).e8Activity.enType ==  midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
         {
        ETG_TRACE_USR4(("\tSourceClass= %d,  SubSource= %d, Activity = %d, Reason = %d", (tU8)Source,(tU16)SubSourceID, Activity, Reason));
           //am_mainConnectionID_t mainConnID = 0;
           clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID(enInternalSrcClass, SubSourceID));
           //getMainConnectionOfSource(enSrcInternal, mainConnID);
           //             if(mainConnID == 0)
           //             {
           //                log(&ControllerPlugin,DLT_LOG_ERROR,"vResponse_AudioRoute,Could not find main connectionID ");
           //                return;
           //             }
           //             clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(mainConnID);
         }
         if((*ReqRouteIterator).e8Activity.enType ==  midw_fi_tcl_e8_SrcActivity::FI_EN_ON)
         {
       ETG_TRACE_USR4(("\tSourceClass= %d,  SubSource= %d, Activity = %d, Reason = %d", (tU8)Source,(tU16)SubSourceID, Activity, Reason));
           am_Error_e err = clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID(enInternalSrcClass, SubSourceID));

           ETG_TRACE_USR4(("RequestSourceOn returned %d for Source %d",err,Source));
             //hard code a reject here for AUX_1
           //if(Source == midw_fi_tcl_e8_AudSource::FI_EN_AUX)
           if(err != E_OK)
           {
              ETG_TRACE_USR4(("Trying to post Reject"));
              midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet oFiDataObject1;

                // Fill the parameters into the (message related) FI data object.
                oFiDataObject1.Source.enType = Source;
                oFiDataObject1.SubSource = SubSourceID;
                   //TBD Reason
                oFiDataObject1.Reason = err;

                if (m_pSender)
                {
                   tU16 ret = m_pSender->u16PostFICommand(oFiDataObject1);
                   ETG_TRACE_USR4(("Posting returnd %d",ret));
                }
           }


           //hookUserConnectionRequest(enSrcInternal,1,mainConnectionID);
         }
         if((*ReqRouteIterator).e8Activity.enType ==  midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE)
         {
       ETG_TRACE_USR4(("\tSourceClass= %d,  SubSource= %d, Activity = %d, Reason = %d", (tU8)Source,(tU16)SubSourceID, Activity, Reason));
           clGeniviAudioCtrlAdapter::RequestSourcePause(SourceID(enInternalSrcClass, SubSourceID));
         }

       }
       else{
         ETG_TRACE_USR4(("bOnRequestAudioRouteStatus(): Not found internal srcID for midew_fi source %d", Source));
       }
     }
   }
   //clGeniviAudioCtrlAdapter::handleSourceStatus(oSrcRouteActStatus.SourceRouteActivity.Source.enType,
   //      oSrcRouteActStatus.SourceRouteActivity.Activity.enType);

   return true;

}

/*******************************************************************************
               Methods of this application
*******************************************************************************/

/************************************************************************
 *FUNCTION     : vSourceRouteActivity_Set
 *DESCRIPTION  : function to set property SourceRouteActivity
 *PARAMETER    : uint8_t,uint8_t,uint8_t,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audioroutemanager::vSourceRouteActivity_Set(uint8_t u8Source,
                                                                             uint16_t u16SubSource,
                                                                             uint8_t u8NextSource,
                                                                             uint8_t u8Resource,
                                                                             uint8_t u8Activity)
{
  ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::vSourceRouteActivity_Set entered, u8Source= %d, u16SubSource= %d, u8NextSource= %d, u8Resource= %d, u8Activity= %d",
    u8Source, u16SubSource, u8NextSource, u8Resource, u8Activity));
   // Check if Service of server is available
   if (m_bSeviceAvailable)
   {
      // Create the (message related) FI data object
      midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet oFiDataObject1;

      // Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SourceRouteActivity.Source.enType = (midw_fi_tcl_e8_AudSource::tenType) u8Source;
      oFiDataObject1.SourceRouteActivity.SubSource = u16SubSource;
      oFiDataObject1.SourceRouteActivity.PossibleNextSource.enType = (midw_fi_tcl_e8_AudSource::tenType) u8NextSource;
      oFiDataObject1.SourceRouteActivity.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.SourceRouteActivity.Activity.enType = (midw_fi_tcl_e8_SrcActivity::tenType) u8Activity;

      if (m_pSender)
         m_pSender->u16PostFICommand(oFiDataObject1);
   }
}

/************************************************************************
* FUNCTION     : vOnServiceAvailable
* DESCRIPTION  : Callback function to get status of fc_audioroutemanager
*                service is unavailable
* PARAMETER    : void
* RETURNVALUE  : tVoid
* HISTORY      :
*              21.01.2014 Vyankatesh VD  Initial Revision.
************************************************************************/
/* virtual */ void amcontrol_clienthandler_fc_audioroutemanager:: vOnServiceAvailable ()
{
   ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable Entered"));

  SET_STATUS(m_ControlReceiverShadow.m_u8StatusReady, STATUS_FC_ARM_SRV_AVLB);
  //m_pControlSenderBase->sendControllerResponse();

  m_ControlSenderBase.response_startup();
}

/************************************************************************
* FUNCTION     : vOnServiceUnavailable
* DESCRIPTION  : Callback function to get status of fc_audioroutemanager
*                service is unavailable
* PARAMETER    : void
* RETURNVALUE  : tVoid
* HISTORY      :
*              21.01.2014 Vyankatesh VD  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_fc_audioroutemanager:: vOnServiceUnavailable ()
{
   ETG_TRACE_USR3(("amcontrol_clienthandler_fc_audioroutemanager::vOnServiceUnavailable Entered"));

   m_ControlSenderBase.m_eGAM_ServiceAvailability = SYP_AM_SRV_STS_UNAVAILABLE;
   UNSET_STATUS(m_ControlReceiverShadow.m_u8StatusReady, STATUS_FC_ARM_SRV_AVLB);

   m_ControlSenderBase.vUpdateSystemPropertyDB(SYP_AM_SRV_STS,SYP_AM_SRV_STS_UNAVAILABLE);
}

/************************************************************************
* FUNCTION     : vRegisterForProperties
* DESCRIPTION  : Register for ARM properties to get the status
* PARAMETER    : void
* RETURNVALUE  : void
* HISTORY      : 03.11.2014 Parusharam J  Initial Revision.
************************************************************************/
void amcontrol_clienthandler_fc_audioroutemanager::vRegisterForProperties()
{
   ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audioroutemanager::vRegisterForProperties entered"));

   // send UpReg message for SourceAvailability
   FIMessaging::FunctionInfo info(GetServiceInfo(), MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY, FIMessaging::enUpreg);
   FIMessaging::fi_tclEmptyMsg oUpreg(info);
   if (m_pSender)
      (void) m_pSender->u16PostFICommand(oUpreg);

   // send UpReg message for RequestAudioRoute
   FIMessaging::FunctionInfo infoReqAudRoute(GetServiceInfo(), MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE, FIMessaging::enUpreg);
   FIMessaging::fi_tclEmptyMsg oUpregReqAudRoute(infoReqAudRoute);
   if (m_pSender)
      (void) m_pSender->u16PostFICommand(oUpregReqAudRoute);
}

// =============================================================================
//
//      ITarget implementation

/* virtual */ FIMessaging::ITarget::AutoRegisterList amcontrol_clienthandler_fc_audioroutemanager:: GetAutoRegisterList ()
{
   // disclose list of properties which should be UpReg'ed automatically
   static tU16 u16PropertyIDs[]
    = {
        MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY
//      , MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY
    };

   return AutoRegisterList(u16PropertyIDs, sizeof(u16PropertyIDs) / sizeof(u16PropertyIDs[0]));
}

// --------------------------------------------------------------------------

/* virtual */ void amcontrol_clienthandler_fc_audioroutemanager:: vDispatchMessage (FIMessaging::FIMessage oMsg)
{
   // callback function invoked from Genivi daemon main thread

   ETG_TRACE_USR1(("vDispatchMessage(): FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))

   bool bSuccess = false;
   switch (oMsg.u8OpCode)
   {
      case CCA_C_U8_OPCODE_STATUS:
         bSuccess = bHandleStatus(oMsg);
         break;

      case CCA_C_U8_OPCODE_ERROR:
         bSuccess = bHandleError(oMsg);
         break;

      case CCA_C_U8_OPCODE_METHODRESULT:
      case CCA_C_U8_OPCODE_ABORTRESULT:
      default:
         break;
   }

   if ( ! bSuccess)
      ETG_TRACE_ERR(("vDispatchMessage() - E R R O R :  unhandled FIMessage for Function %x.%x.%u received"
              , oMsg.u16ServiceID, oMsg.u16FunctionID, oMsg.u8OpCode))
}


// --------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audioroutemanager:: bHandleStatus (const FIMessaging::FIMessage& oMsg)
{
   switch (oMsg.u16FunctionID)
   {
      case MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY   : return bOnSourceRouteActivityStatus(oMsg);
      case MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY      : return bOnSourceAvailabilityStatus(oMsg);
      case MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE       : return bOnRequestAudioRouteStatus(oMsg);

      default                                                   : return false;
   }
}

tVoid amcontrol_clienthandler_fc_audioroutemanager::vSetAudioSource(uint8_t source, tU16 subSource,uint8_t nextSource,uint8_t Resource,uint8_t Activity)
{
  ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAudioSource called"));
  // Check if Service of server is available
  if( m_bSeviceAvailable )
  {
    // Create the (message related) FI data object
    midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart oFiDataObject1;

    //Fill the parameters into the (message related) FI data object.
    oFiDataObject1.SourceRouteActivity.Source.enType = (midw_fi_tcl_e8_AudSource::tenType) source;
    oFiDataObject1.SourceRouteActivity.PossibleNextSource.enType = (midw_fi_tcl_e8_AudSource::tenType)nextSource;
  oFiDataObject1.SourceRouteActivity.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Resource;
    oFiDataObject1.SourceRouteActivity.Activity.enType = (midw_fi_tcl_e8_SrcActivity::tenType)Activity;
  oFiDataObject1.SourceRouteActivity.SubSource = subSource;


    if (m_pSender)
       (void) m_pSender->u16PostFICommand(oFiDataObject1);
    else
       ETG_TRACE_FATAL(("vSetAudioSource(): E R R O R - invalid pointer to m_pSender"))
  }
  else
  {
    ETG_TRACE_USR4(("amcontrol_clienthandler_fc_audiomanager::vSetAudioSource called,Service is not available"));
  }
}
// --------------------------------------------------------------------------

bool amcontrol_clienthandler_fc_audioroutemanager:: bHandleError (const FIMessaging::FIMessage& oMsg)
{
   switch (oMsg.u16FunctionID)
   {
      case MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY   : return bOnSourceRouteActivityError(oMsg);

      default                                                   : return false;
   }
}

// --------------------------------------------------------------------------


